/*This makes the timeout variable global so all functions can access it.*/
var timeout;

function loaded() {
    $('.loader').fadeOut("slow");
}
$(document).ready(function(){ 
    timeout = setTimeout(loaded, 1000);
    
    $('#submit').on('click', function(e){
        $('.loader').fadeIn();
        clearTimeout(timeout);
    });

    $("#kecamatan").change(function(){               
        $.ajax({
            type: "POST", // Method pengiriman data bisa dengan GET atau POST
            url: "option.php?act=kecamatan", // Isi dengan url/path file php yang dituju
            data: {kecamatan : $("#kecamatan").val(), bentuk_pendidikan_id : $("#bentuk_pendidikan_id").val()}, // data yang akan dikirim ke file yang 
            dataType: "json",
            beforeSend: function(e) {
            if(e && e.overrideMimeType) {
                e.overrideMimeType("application/json;charset=UTF-8");
            }
            },
            success: function(response){ 
            $("#sekolah").html(response.sekolah).show();
            $("#data").html("").hide();
            },
            error: function (xhr, ajaxOptions, thrownError) { // Ketika ada error
            alert(thrownError); // Munculkan alert error
            }
        });
    });

    $("#bentuk_pendidikan_id").change(function(){               
        $.ajax({
            type: "POST", // Method pengiriman data bisa dengan GET atau POST
            url: "option.php?act=kecamatan", // Isi dengan url/path file php yang dituju
            data: {kecamatan : $("#kecamatan").val(), bentuk_pendidikan_id : $("#bentuk_pendidikan_id").val()}, // data yang akan dikirim ke file yang 
            dataType: "json",
            beforeSend: function(e) {
            if(e && e.overrideMimeType) {
                e.overrideMimeType("application/json;charset=UTF-8");
            }
            },
            success: function(response){ 
            $("#sekolah").html(response.sekolah).show();
            $("#data").html("").hide();
            },
            error: function (xhr, ajaxOptions, thrownError) { // Ketika ada error
            alert(thrownError); // Munculkan alert error
            }
        });
    });

    $("#sekolah").change(function(){               
        $.ajax({
            type: "POST", // Method pengiriman data bisa dengan GET atau POST
            url: "option.php?act=sekolah", // Isi dengan url/path file php yang dituju
            data: {sekolah : $("#sekolah").val()}, // data yang akan dikirim ke file yang 
            dataType: "json",
            beforeSend: function(e) {
            if(e && e.overrideMimeType) {
                e.overrideMimeType("application/json;charset=UTF-8");
            }
            },
            success: function(response){ 
            // alert(response.sekolah);
            $("#data").html(response.sekolah).show();
            },
            error: function (xhr, ajaxOptions, thrownError) { // Ketika ada error
            alert(thrownError); // Munculkan alert error
            }
        });
    });
    
    $('#rms-wizard').stepWizard({
        stepTheme: 'defaultTheme',/*defaultTheme,steptheme1,steptheme2*/
        allstepClickable: false,
        compeletedStepClickable: true,
        stepCounter: true,
        StepImage: true, 
        animation: true,
        animationClass: "fadeIn",
        stepValidation: true,
        validation : true, 
        field: {
            bentuk_pendidikan_id : {
            required : true,
            },
            kecamatan : {
            required : true,
            },
            sekolah : { 
                required : true, 
                minlength: 2,
                Regex: /^[a-zA-Z0-9]+$/,  
            },
            username : { 
                required : true, 
                minlength: 2,
                Regex: /^[a-zA-Z0-9]+$/,  
            },
            password : {
                required : true,
                minlength : 5,
                maxlength : 20,
                Regex: /^(?=.*[0-9_\W]).+$/, 
            },
            cpassword : {
            required : true,
            minlength : 5,
            maxlength : 20,
            Regex: /^(?=.*[0-9_\W]).+$/,
            },
            email:{
                required : true,
                Regex: /^(([^<>()\[\]\\.,;:\s@"]+(\.[^<>()\[\]\\.,;:\s@"]+)*)|(".+"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/,
            },
            database_name : { 
                required : true,
            },
            database_user : { 
                required : true,
            },
            database_password : { 
                required : true,
            },
        },
        message: {
            username: "Username tidak boleh kosong!",
            password: "Password tidak boleh kosong!",
            cpassword: "Password harus cocok!",
            database_name: "Nama DATABASE harus ditentukan!",
            database_user: "User DATABASE harus ditentukan!",
            database_password: "Password DATABASE harus ditentukan!",
        }
        
    });

    $('#restartInstall').on('click', function(e){
        e.preventDefault();
        window.location.href = "../install";
    });

    $('#reconnectDB').on('click', function(e){
        e.preventDefault();
        window.location.reload();
    })
});