@extends('layouts.master')
@section('title', 'Beranda Situs Resmi')
@section('content')
<style type="text/css">
    .scroller{
        text-align: center;
    }
    @media only screen and (max-width: 767px) {
        div.i-scroller h2{
            font-size: 12px;
        }
    }
</style>
<!-- Hero section -->
<section class="hero-section">
    <div class="hero-slider owl-carousel">
        @if($banner)
            @foreach($banner as $row)
            <div class="hs-item set-bg" data-setbg="{{ url('assets/files/banner/'.$row->picture.'?time='.time()) }}">
                <div class="hs-text">
                    <div class="container">
                        <div class="row">
                            <div class="col-lg-8">
                                {{-- <div class="hs-subtitle">{{ $row->name != "-" ? $row->name : "" }}</div> --}}
                                <h2 class="hs-title">{{ $row->name == "-" ? "" : $row->name }}</h2>
                                <p class="hs-des">{{ $row->description == "-" ? "" : $row->description }}</p>
                                <!-- <div class="site-btn">GET STARTED</div> -->
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            @endforeach
        @endif
    </div>
</section>
<!-- Hero section end -->


<!-- Counter section  -->
<section class="counter-section">
    <div class="container">
        <div class="row">
            <div class="col-lg-12 col-md-12">
                <div class="big-icon">
                    <i class="fa fa-info"></i>
                </div>
                <div class="counter-content">
                    <div class="scroller">
                    @if($runningText)
                        @foreach($runningText as $row)
                            <div class="i-scroller"><h2>{{ $row->text }}</h2></div>
                        @endforeach
                    @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- Counter section end -->


<!-- Event section -->
<section class="event-section spad">
    <div class="container">
        <div class="section-title text-center">
            <h3>Kegiatan Sekolah</h3>
            <p>Dokumentasi Kegiatan Sekolah</p>
        </div>
        <div class="row">
            @if($kegiatan)
                @foreach($kegiatan as $row)
                <div class="col-md-6 event-item">
                    <div class="event-thumb">
                        <img src="<?php if($row->picture != NULL){ echo url('assets/files/kegiatan/'.$row->picture.'?time='.time()); }else{ echo url('assets/frontend/img/no-picture.png?time='.time()); } ?>" alt="">
                        <div class="event-date">
                            <span>{{ Helper::tgl_indo($row->tanggal_kegiatan) }}</span>
                        </div>
                    </div>
                    <div class="event-info">
                        <h4>{{ $row->title }}</h4>
                        <p><i class="fa fa-map-marker"></i> {{ $row->lokasi_kegiatan }}</p>
                    </div>
                </div>
                @endforeach
            @endif
            <a href="#" id="loadMore">Load More</a>
        </div>
    </div>
</section>
<!-- Event section end -->


<!-- Fact section -->
<section class="fact-section spad set-bg" data-setbg="{{ url('assets/files/banner/'.Helper::get_banner()->picture).'?time='.time() }}">
    <div class="container">
        <div class="row">
            <div class="col-sm-6 col-lg-3 fact">
                <div class="fact-icon">
                    <i class="ti-crown"></i>
                </div>
                <div class="fact-text">
                    <h2>{{ $progress ? $progress->jml_ptk : 0 }}</h2>
                    <p>Guru</p>
                </div>
            </div>
            <div class="col-sm-6 col-lg-3 fact">
                <div class="fact-icon">
                    <i class="ti-briefcase"></i>
                </div>
                <div class="fact-text">
                    <h2>{{ $progress ? $progress->jml_pegawai : 0 }}</h2>
                    <p>Tenaga Kependidikan</p>
                </div>
            </div>
            <div class="col-sm-6 col-lg-3 fact">
                <div class="fact-icon">
                    <i class="ti-user"></i>
                </div>
                <div class="fact-text">
                    <h2>
                        {{ $progress ? $progress->jml_pd : 0 }}
                    </h2>
                    <p>Siswa</p>
                </div>
            </div>
            <div class="col-sm-6 col-lg-3 fact">
                <div class="fact-icon">
                    <i class="ti-pencil-alt"></i>
                </div>
                <div class="fact-text">
                    <h2>
                        {{ $progress ? $progress->jml_rombel : 0 }}
                    </h2>
                    <p>Rombel</p>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- Fact section end-->

<!-- Team section  -->
    <section class="team-section spad">
        <div class="container">
            <div class="section-title text-center">
                <h3>MANAGEMENT SEKOLAH</h3>
                <p>Daftar Tenaga Pendidik dan Administrasi Sekolah</p>
            </div>
            <div class="row">
                @if($managementsekolah)
                    @foreach($managementsekolah as $row)
                    <div class="col-md-6 col-lg-3 management">
                        <div class="member">
                            <div class="member-pic set-bg" data-setbg="<?php if($row->foto != NULL){ echo url('assets/files/sekolah/'.$row->foto.'?time='.time()); }else{ echo url('assets/frontend/img/no-picture.png?time='.time()); } ?>">
                                <div class="member-social">
                                    <a href="{{ $row->facebook }}" target="_blank" title="kunjungi facebook"><i class="fa fa-facebook"></i></a>
                                    <a href="{{ $row->twitter }}" target="_blank" title="kunjungi twitter"><i class="fa fa-twitter"></i></a>
                                    <a href="{{ $row->instagram }}" target="_blank" title="kunjungi instagram"><i class="fa fa-instagram"></i></a>
                                </div>
                            </div>
                            <h5>{{ $row->nama }}</h5>
                            <p>{{ $row->jabatan }}</p>
                        </div>
                    </div>
                    @endforeach
                @endif
                <a href="#" id="loadManagement">Load More</a>
            </div>
        </div>
    </section>
    <!-- Team section end -->


<!-- Gallery section -->
<div class="gallery-section">
    <div class="gallery">
        <div class="grid-sizer"></div>
        <?php $no=0; if($gallery): foreach($gallery as $row){ $no++; ?>
        <div class="gallery-item <?php if($no == 1 || $no == 5){ echo 'gi-big'; }elseif($no == 4 || $no == 6){ echo 'gi-long'; } ?> set-bg" data-setbg="{{ url('assets/files/gallery/'.$row->picture.'?time='.time()) }}">
            <a class="img-popup" href="{{ url('assets/files/gallery/'.$row->picture.'?time='.time()) }}"><i class="ti-plus"></i></a>
        </div>
        <?php } endif; ?>
    </div>
</div>
<!-- Gallery section -->


<!-- Blog section -->
<section class="blog-section spad">
    <div class="container">
        <div class="section-title text-center">
            <h3>Konten Blog</h3>
            <p>Update konten seputar sekolah</p>
        </div>
        <div class="row">
            @if($blog)
                @foreach($blog as $row)
                <div class="col-xl-6 blog">
                    <div class="blog-item">
                        <div class="blog-thumb set-bg" data-setbg="<?php if($row->picture != NULL){ echo url('assets/files/blog/'.$row->picture.'?time='.time()); }else{ echo url('assets/frontend/img/no-picture.png?time='.time()); } ?>"></div>
                        <div class="blog-content">
                            <h4><a href="{{url('blog/'.$row->slug)}}" style="text-decoration: none; color:black;">{{ $row->title }}</a></h4>
                            <div class="blog-meta">
                                <span><i class="fa fa-calendar-o"></i> {{ $row->updated_at != NULL ? Helper::tgl_indo($row->updated_at) : Helper::tgl_indo($row->created_at) }}</span>
                                <span><i class="fa fa-user"></i> {{ $row->nama_author }}</span>
                            </div>
                            <p><?php echo strip_tags(substr($row->content, 0, 100)); ?>... <a href="{{url('blog')}}/{{$row->slug}}">Read more</a></p>
                        </div>
                    </div>
                </div>
                @endforeach
            @endif
            <a href="#" id="loadBlog">Load More</a>
        </div>
    </div>
</section>
<!-- Blog section -->

@endsection

@push('scripts')
<script type="text/javascript" src="{{ url('assets/frontend/js/jquery.scroller.js') }}"></script>
@endpush
