@extends('layouts.master')
@section('title', 'Data Siswa')
@section('content')

<!-- Breadcrumb section -->
<div class="site-breadcrumb">
	<div class="container">
		<a href="#"><i class="fa fa-home"></i> Home</a> <i class="fa fa-angle-right"></i>
		<span>Data Siswa</span>
	</div>
</div>
<!-- Breadcrumb section end -->


<!-- About section -->
<section class="about-section spad pt-0">
	<div class="container">
		<div class="section-title text-center">
			<h3>Data Siswa</h3>
			<p>Table Data Siswa</p>
		</div>
		<div class="row" style="font-size:14px;">
			<div class="col-lg-12">
				<h4>Siswa</h4>
				<hr>
				<ul class="nav nav-tabs">
					<li class="active"><a href="#siswatingkat" data-toggle="tab">Tingkat</a></li>
					<li><a href="#siswaagama" data-toggle="tab">Agama</a></li>
					<li><a href="#siswaumur" data-toggle="tab">Umur</a></li>
					<li><a href="#siswajeniskelamin" data-toggle="tab">Jenis Kelamin</a></li>
					<li><a href="#siswadaftar" data-toggle="tab">Daftar</a></li>
				</ul>

				<div class="tab-content">
					<div id="siswatingkat" class="tab-pane fade in active">
						<table class="table table-striped table-bordered table-hover">
							<thead>
								<tr>
									<td style="text-align: center;">Tingkat</td>
                					<td style="text-align: center;">Jumlah</td>
								</tr>
							</thead>
							<tbody>
                                <?php $total = 0; ?>
                                @if($siswa_tingkat)
								@foreach($siswa_tingkat as $row)
								<?php $total += $row->jumlah; ?>
								<tr>
									<td>{{$row->rombel}}</td>
									<td>{{$row->jumlah}}</td>
								</tr>
                                @endforeach
                                @endif
								<tr>
									<td style="font-weight: bold;">Total</td>
									<td style="font-weight: bold;">
										{{ $total }}
									</td>
								</tr>
							</tbody>
						</table>
					</div>
					<div id="siswaagama" class="tab-pane fade">
						<table class="table table-striped table-bordered table-hover">
							<thead>
								<tr>
									<td style="text-align: center;">Agama</td>
                					<td style="text-align: center;">Jumlah</td>
								</tr>
							</thead>
							<tbody>
                                <?php $total = 0; ?>
                                @if($agama)
								@foreach($agama as $row)
								<?php $total += $row->jumlah; ?>
								<tr>
									<td>{{ $row->agama }}</td>
									<td>{{ $row->jumlah }}</td>
								</tr>
                                @endforeach
                                @endif
								<tr>
									<td style="font-weight: bold;">Total</td>
									<td style="font-weight: bold;">
										{{ $total }}
									</td>
								</tr>
							</tbody>
						</table>
					</div>
					<div id="siswaumur" class="tab-pane fade">
						<table class="table table-striped table-bordered table-hover">
							<thead>
								<tr>
									<td style="text-align: center;">Umur</td>
                					<td style="text-align: center;">Jumlah</td>
								</tr>
							</thead>
							<tbody>
                                <?php $total = 0; ?>
                                @if($usiasiswa)
								@foreach($usiasiswa as $row)
								<?php $total += $row->jumlah; ?>
								<tr>
									<td>{{ $row->usia }}</td>
									<td>{{ $row->jumlah }}</td>
								</tr>
                                @endforeach
                                @endif
								<tr>
									<td style="font-weight: bold;">Total</td>
									<td style="font-weight: bold;">{{ $total }}</td>
								</tr>
							</tbody>
						</table>
					</div>
					<div id="siswajeniskelamin" class="tab-pane fade">
						<table class="table table-striped table-bordered table-hover">
							<thead>
								<tr>
									<td style="text-align: center;">Jenis Kelamin</td>
                					<td style="text-align: center;">Jumlah</td>
								</tr>
							</thead>
							<tbody>
                                <?php $total = 0; ?>
                                @if($jksiswa)
								@foreach($jksiswa as $row)
								<?php $total += $row->jumlah; ?>
								<tr>
									<td>{{ $row->jenis_kelamin }}</td>
									<td>{{ $row->jumlah }}</td>
								</tr>
                                @endforeach
                                @endif
								<tr>
									<td style="font-weight: bold;">Total</td>
									<td style="font-weight: bold;">{{ $total }}</td>
								</tr>
							</tbody>
						</table>
					</div>
					<div id="siswadaftar" class="tab-pane fade">
						<div class="table-responsive">
							<table id="datatables" class="table table-striped table-bordered table-hover" width="100%">
								<thead>
									<tr>
										<td style="text-align: center;">Nama</td>
	                					<td style="text-align: center;">Jenis Kelamin</td>
	                					<td style="text-align: center;">NISN</td>
	                					<td style="text-align: center;">Kelas</td>
									</tr>
								</thead>
								<tbody>
                                    @if($daftarsiswa)
									@foreach($daftarsiswa as $row)
									<tr>
										<td>{{ $row->nama_siswa }}</td>
										<td>{{ $row->jenis_kelamin }}</td>
										<td>{{ $row->nisn }}</td>
										<td>{{ $row->kelas }}</td>
									</tr>
                                    @endforeach
                                    @endif
								</tbody>
							</table>
						</div>
					</div>
				</div>
			</div>

			<!-- <div class="col-lg-6">
				<h4>Siswa Mengulang</h4>
				<hr>
				<ul class="nav nav-tabs">
					<li class="active"><a href="#siswamengulangtingkat" data-toggle="tab">Tingkat</a></li>
					<li><a href="#siswamengulangumur" data-toggle="tab">Umur</a></li>
					<li><a href="#siswamengulangjeniskelamin" data-toggle="tab">Jenis Kelamin</a></li>
				</ul>

				<div class="tab-content">
					<div id="siswamengulangtingkat" class="tab-pane fade in active">
						<table class="table table-striped table-bordered table-hover">
							<thead>
								<tr>
									<td style="text-align: center;">Tingkat</td>
                					<td style="text-align: center;">Jumlah</td>
								</tr>
							</thead>
							<tbody>
							</tbody>
						</table>
					</div>
					<div id="siswamengulangumur" class="tab-pane fade">
						<table class="table table-striped table-bordered table-hover">
							<thead>
								<tr>
									<td style="text-align: center;">Umur</td>
                					<td style="text-align: center;">Jumlah</td>
								</tr>
							</thead>
							<tbody>
							</tbody>
						</table>
					</div>
					<div id="siswamengulangjeniskelamin" class="tab-pane fade">
						<table class="table table-striped table-bordered table-hover">
							<thead>
								<tr>
									<td style="text-align: center;">Jenis Kelamin</td>
                					<td style="text-align: center;">Jumlah</td>
								</tr>
							</thead>
							<tbody>
							</tbody>
						</table>
					</div>
				</div>
			</div> -->
		</div>

		<!-- <div class="row" style="font-size:14px;">
			<div class="col-lg-6">
				<h4>Siswa Baru</h4>
				<hr>
				<ul class="nav nav-tabs">
					<li class="active"><a href="#siswabaruumur" data-toggle="tab">Umur</a></li>
          			<li><a href="#siswabarujeniskelamin" data-toggle="tab">Jenis Kelamin</a></li>
				</ul>

				<div class="tab-content">
					<div id="siswabaruumur" class="tab-pane fade in active">
						<table class="table table-striped table-bordered table-hover">
							<thead>
								<tr>
									<td style="text-align: center;">Umur</td>
                					<td style="text-align: center;">Jumlah</td>
								</tr>
							</thead>
							<tbody>
							</tbody>
						</table>
					</div>
					<div id="siswabarujeniskelamin" class="tab-pane fade">
						<table class="table table-striped table-bordered table-hover">
							<thead>
								<tr>
									<td style="text-align: center;">Jenis Kelamin</td>
                					<td style="text-align: center;">Jumlah</td>
								</tr>
							</thead>
							<tbody>
							</tbody>
						</table>
					</div>
				</div>
			</div>

			<div class="col-lg-6">
				<h4>Siswa Lulus</h4>
				<hr>
				<ul class="nav nav-tabs">
					<li class="active"><a href="#siswalulusumur" data-toggle="tab">Umur</a></li>
          			<li><a href="#siswalulusjeniskelamin" data-toggle="tab">Jenis Kelamin</a></li>
				</ul>

				<div class="tab-content">
					<div id="siswalulusumur" class="tab-pane fade in active">
						<table class="table table-striped table-bordered table-hover">
							<thead>
								<tr>
									<td style="text-align: center;">Umur</td>
                					<td style="text-align: center;">Jumlah</td>
								</tr>
							</thead>
							<tbody>
							</tbody>
						</table>
					</div>
					<div id="siswalulusjeniskelamin" class="tab-pane fade">
						<table class="table table-striped table-bordered table-hover">
							<thead>
								<tr>
									<td style="text-align: center;">Jenis Kelamin</td>
                					<td style="text-align: center;">Jumlah</td>
								</tr>
							</thead>
							<tbody>
							</tbody>
						</table>
					</div>
				</div>
			</div>
		</div> -->
	</div>
</section>
<!-- About section end-->

@endsection

@push('style')
<!-- DataTables -->
<link rel="stylesheet" type="text/css" href="{{url('assets/backend/DataTables')}}/css/jquery.dataTables.min.css">
<link rel="stylesheet" type="text/css" href="{{url('assets/backend/DataTables')}}/css/rowReorder.dataTables.min.css">
<link rel="stylesheet" type="text/css" href="{{url('assets/backend/DataTables')}}/css/responsive.dataTables.min.css">
@endpush

@push('scripts')
<!-- DataTables -->
<script src="{{url('assets/backend/DataTables')}}/js/jquery.dataTables.min.js"></script>
<script src="{{url('assets/backend/DataTables')}}/js/dataTables.rowReorder.min.js"></script>
<script src="{{url('assets/backend/DataTables')}}/js/dataTables.responsive.min.js"></script>
<script type="text/javascript">
	$('#datatables').DataTable({
      "stateSave": true,
      "searching" : true,
      "autoWidth": true
    });
</script>
@endpush
