<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class KegiatanItem extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'title' => $this->title,
            'caption' => $this->caption,
            'tanggal_kegiatan' => $this->tanggal_kegiatan,
            'lokasi_kegiatan' => $this->lokasi_kegiatan,
            'picture' => $this->picture != NULL ? url('assets/files/kegiatan/'.$this->picture.'?time='.time()) : NULL,
            'slug' => $this->slug,
            'status' => $this->status,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
        ];
    }
}
